<?php
if (!defined('FUNC_FILE')) die("Illegal File Access");

// Old filter
require_once("old_filters.php");

// Format Time filter
function formatTimestamp($time) {
	global $datetime;
    setlocale(LC_TIME, ""._LOCALE."");
    preg_match("/([0-9]{4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})/", $time, $datetime);
    $datetime = strftime(""._DATESTRING."", mktime($datetime[4],$datetime[5],$datetime[6],$datetime[2],$datetime[3],$datetime[1]));
    $datetime = ucfirst($datetime);
    return $datetime;
}

// Display Time filter
function displayTime($sec) {
	$minutes = floor($sec / 60);
	$seconds = $sec % 60;
	$content = ($minutes == 0) ? "".$seconds." "._SEC."." : "".$minutes." "._MIN.". ".$seconds." "._SEC.".";
	return $content;
}

// Size filter
function files_size($size) {
	if ($size >= 1073741824) {
		$mysize = "".round(($size / 1073741824), 2)." GB";
	} elseif ($size >= 1048576) {
		$mysize = "".round(($size / 1048576), 2)." MB";
	} elseif ($size >= 1024) {
		$mysize = "".round(($size / 1024), 2)." KB";
	} else {
		$mysize = "".$size." Bytes";
	}
    return $mysize;
}

// Format new graphic
function new_graphic($data) {
    $data = mktime() - $data;
	if ($data < 86400) $img = "<img src=\"images/new_day.gif\" title=\""._NEWTODAY."\">";
	if (($data > 86400) AND ($data < 259200)) $img = "<img src=\"images/new_3day.gif\" title=\""._NEWLAST3DAYS."\">";
	if (($data > 259200) AND ($data < 604800)) $img = "<img src=\"images/new_week.gif\" title=\""._NEWTHISWEEK."\">";
	return $img;
}

// Format vote graphic
function vote_graphic($votes, $total) {
	if (intval($votes)) {
		$result = substr($total / $votes, 0, 4);
		$image = round($result);
		$img = "$result/$votes<img src=\"images/articles/stars-".$image.".gif\" border=\"0\" alt=\""._AVERAGESCORE.": $result\" title=\""._AVERAGESCORE.": $result\">";
	} else {
		$img = "0.00/0<img src=\"images/articles/stars-0.gif\" border=\"0\" alt=\""._AVERAGESCORE.": 0\" title=\""._AVERAGESCORE.": 0\">";
	}
	return $img;
}

// Lang filter
function cutstr($linkstrip, $strip) {
	$linkstrip = stripslashes($linkstrip);
	if (strlen($linkstrip) > $strip) $linkstrip = "".substr($linkstrip, 0, $strip)."...";
	return $linkstrip;
}

// HTML and Word filter
function text_filter($message, $type="") {
	include("config/config_global.php");
	if (intval($type) == 2) {
		$message = htmlspecialchars(trim($message), ENT_QUOTES);
	} else {
		$message = strip_tags(urldecode($message));
		$message = htmlspecialchars(trim($message), ENT_QUOTES);
	}
	if ($CensorMode && intval($type != 1)) {
		$CensorList = explode(",", $CensorList);
		foreach ($CensorList as $key => $val) $message = preg_replace("/$val/i", $CensorReplace, $message);
	}
	return $message;
}

// Analyzer of variables
function variables() {
	if ($_GET) {
		echo "<b>GET</b> - ";
		$a = 0;
		foreach ($_GET as $var_name=>$var_value) {
			if ($a == 0) {
				echo "$var_name=$var_value";
			} else {
				echo ", $var_name=$var_value";
			}
			$a++;
		}
	}
	if ($_POST) {
		echo "<br /><br /><b>POST</b> - ";
		$a = 0;
		foreach ($_POST as $var_name=>$var_value) {
			if ($a == 0) {
				echo "$var_name=$var_value";
			} else {
				echo ", $var_name=$var_value";
			}
			$a++;
		}
	}
	if ($_COOKIE) {
		echo "<br /><br /><b>COOKIE</b> - ";
		$a = 0;
		foreach ($_COOKIE as $var_name=>$var_value) {
			if ($a == 0) {
				echo "$var_name=$var_value";
			} else {
				echo ", $var_name=$var_value";
			}
			$a++;
		}
	}
	if ($_FILES) {
		echo "<br /><br /><b>FILES</b> - ";
		$a = 0;
		foreach ($_FILES as $var_name=>$var_value) {
			if ($a == 0) {
				echo "$var_name=$var_value";
			} else {
				echo ", $var_name=$var_value";
			}
			$a++;
		}
	}
}
?>